<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\ResponseData;
use App\Http\Controllers\Controller;
use App\Http\Resources\Question\QuestionResource;
use App\Models\Question;
use App\Models\QuestionValue;
use App\Models\Service;
use Carbon\Carbon;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class QuestionController extends Controller
{
    public function index(Request $req)
    {
        $questions = Question::where('service_id', $req->service)->orderBy('sort_order')->get();
        return QuestionResource::collection($questions);
    }

    public function details($id)
    {
        $question = Question::where('id', $id)->first();
        return ResponseData::success('', new QuestionResource($question));
    }

    public function create(Request $req)
    {
        $service = $req->service;
        $title = $req->title;
        $extra = $req->extra;
        $shortTitle = $req->short_title;
        $type = $req->type;
        $next_question = $req->next_question;
        $is_required = $req->is_required;
        $values = json_decode($req->q_values, true);

        DB::beginTransaction();
        try {
            if ($next_question == "" || $next_question < 1) {
                $next_question = null;
            }
            if ($type == 1 || $type == 5) {
                $check = Question::where('type', $type)->count();
                if ($check > 0) {
                    return ResponseData::error('نمیتوانید از این نوع سوال بیش از یک مورد ایجاد کنید');
                }
            }
            $count = Question::where('service_id', $service)->count();
            $question = Question::create([
                'service_id' => $service,
                'title' => $title,
                'short_title' => $shortTitle,
                'type' => $type,
                'extra' => $extra,
                'sort_order' => $count - 1,
                'next_question' => $next_question,
                'is_required' => $is_required,
            ]);
            Question::where('service_id', $service)->where('type', 1)->update(['sort_order' => $count]);
            Question::where('service_id', $service)->where('type', 5)->update(['sort_order' => $count + 1]);
            if (count($values) > 0) {
                foreach ($values as $value) {
                    $next = null;
                    if ($value['next_question'] != "" && $value['next_question'] > 0) {
                        $next = $value['next_question'];
                    }
                    QuestionValue::create([
                        'question_id' => $question->id,
                        'value' => $value['value'],
                        'extra' => $value['extra'],
                        'description' => $value['description'],
                        'icon' => $value['icon'],
                        'type' => $value['type'],
                        'next_question' => $next
                    ]);
                }
            }
            Service::where('id', $service)->update(['updated_at' => Carbon::now()]);
            DB::commit();
            return ResponseData::success('سوال با موفقیت ثبت شد');
        } catch (Exception $ex) {
            DB::rollBack();
            return ResponseData::error($ex->getMessage());
            return ResponseData::error('خطا در ثبت سوال ');
        }
    }


    public function update(Request $req)
    {
        $id = $req->id;
        $service = $req->service;
        $title = $req->title;
        $extra = $req->extra;
        $shortTitle = $req->short_title;
        $type = $req->type;
        $values = json_decode($req->q_values, true);
        $next_question = $req->next_question;
        $is_required= $req->is_required;

        DB::beginTransaction();
        try {
            if ($next_question == "" || $next_question < 1) {
                $next_question = null;
            }
            if ($type == 1 || $type == 5) {
                $check = Question::where('id', $id)->where('type', $type)->count();
                if ($check > 1) {
                    return ResponseData::error('نمیتوانید از این نوع سوال بیش از یک مورد ایجاد کنید');
                }
            }
            $question = Question::where('id', $id)->first();
            $question->service_id = $service;
            $question->title = $title;
            $question->short_title = $shortTitle;
            $question->type = $type;
            $question->extra = $extra;
            $question->next_question = $next_question;
            $question->is_required = $is_required;

            $question->save();

            QuestionValue::where('question_id', $id)->delete();
            if (count($values) > 0) {
                foreach ($values as $value) {
                    $next = null;
                    if ($value['next_question'] != "" && $value['next_question'] > 0) {
                        $next = $value['next_question'];
                    }
                    QuestionValue::create([
                        'question_id' => $question->id,
                        'value' => $value['value'],
                        'extra' => $value['extra'],
                        'description' => $value['description'],
                        'icon' => $value['icon'],
                        'type' => $value['type'],
                        'next_question' => $next
                    ]);
                }
            }
            DB::commit();
            return ResponseData::success('سوال با موفقیت ثبت شد');
        } catch (Exception $ex) {
            DB::rollBack();
            return ResponseData::error($ex->getMessage());
            return ResponseData::error('خطا در ثبت سوال');
        }
    }

    public function changeOrder(Request $req)
    {
        $id = $req->id;
        $service = $req->service;
        $order = $req->order;

        DB::beginTransaction();
        try {
            $currentOrder = Question::where('service_id', $service)->where('id', $id)->first();
            if ($currentOrder->sort_order > $order) {
                Question::where('service_id', $service)->where('sort_order', '>=', $order)->where('sort_order', '<', $currentOrder->sort_order)->update(['sort_order' => DB::raw('sort_order+1')]);
            } else {
                Question::where('service_id', $service)->where('sort_order', '>', $currentOrder->sort_order)->where('sort_order', '<=', $order)->update(['sort_order' => DB::raw('sort_order-1')]);
            }
            Question::where('service_id', $service)->where('id', $id)->update(['sort_order' => $order]);
            DB::commit();

            $questions = Question::where('service_id', $req->service)->orderBy('sort_order')->get();
            return QuestionResource::collection($questions);
        } catch (Exception $ex) {
            DB::rollBack();
            return ResponseData::error('خطا در انجام عملیات');
        }
    }

    public function delete(Request $req)
    {
        $q = Question::where('id', $req->id)->first();
        Question::where('service_id', $q->service_id)->where('sort_order', '>', $q->sort_order)->update(['sort_order' => DB::raw('sort_order-1')]);
        Question::where('next_question', $q->id)->update(['next_question' => null]);
        QuestionValue::where('next_question', $q->id)->update(['next_question' => null]);
        Question::where('id', $req->id)->delete();
        $questions = Question::where('service_id', $q->service_id)->orderBy('sort_order')->get();
        return QuestionResource::collection($questions);
    }

    public function setNextQuestion(Request $req)
    {
        $type = $req->type;
        $id = $req->id;
        $next = $req->next_id;
        if ($next == 0) {
            $next = null;
        }
        if ($type == "main") {

            Question::where('id', $id)->update(['next_question' => $next]);
        } else {
            QuestionValue::where('id', $id)->update(['next_question' => $next]);
        }

        return ResponseData::success('done');
    }

    public function fixSorting()
    {
        $categories = Question::select('service_id')->distinct()->get();
        Question::where('type', 1)->update(['sort_order' => 100]);
        Question::where('type', 5)->update(['sort_order' => 101]);
        foreach ($categories as $cat) {
            $data = Question::where('service_id', $cat->service_id)->orderBy('sort_order')->get();
            for ($i = 1; $i <= count($data); $i++) {
                Question::where('id', $data[$i - 1]->id)->update(['sort_order' => $i]);
            }
        }
        return ResponseData::success('done');
    }
}
