<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\ResponseData;
use App\Http\Controllers\Controller;
use App\Http\Resources\Protest\ProtestResource;
use App\Models\Protest;
use Illuminate\Http\Request;

class ProtestController extends Controller
{
    public function index(Request $req)
    {
        $protests = Protest::where('status', $req->status)->orderBy('created_at')->paginate(20);
        return ProtestResource::collection($protests);
    }

    public function check(Request $req)
    {
        Protest::where('id', $req->id)->update(['status' => 'checked']);
        return ResponseData::success('عملیات با موفقیت انجام شد');
    }
}
