<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\ResponseData;
use App\Http\Controllers\Controller;
use App\Http\Resources\AdminOrder\AdminOrderResource;
use App\Http\Resources\OrderResult\OrderResultResource;
use App\Models\Expert;
use App\Models\Order;
use App\Models\OrderProposal;
use App\Models\OrderResult;
use App\Models\Service;
use App\Services\Bank\Bank;
use App\Services\NotificationService\NotificationService;
use App\Services\OrderStatusService\OrderStatusService;
use Carbon\Carbon;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class OrderController extends Controller
{
    public function index(Request $req)
    {
        $orders = Order::query();
        if ($req->status) {
            $orders->where('status', $req->status);
        }
        $data = $orders->orderByDesc('created_at')->paginate(20);
        return AdminOrderResource::collection($data);
    }


    public function details($id)
    {
        $order = Order::where('id', $id)->first();
        return ResponseData::success('order details', new AdminOrderResource($order));
    }

    public function cancelOrder(Request $req)
    {
        Order::where('id', $req->id)->update(['status' => 'canceled', 'canceled_at' => Carbon::now()]);
        OrderStatusService::setStatus($req->id, 'canceled');
        return ResponseData::success('سفارش با موفقیت لغو شد');
    }

    public function setExpert(Request $req)
    {
        $id = $req->id;
        $expert_id = $req->expert_id;

        try {
            $order = Order::where('id', $id)->first();

            // $pastOrders = Order::where('expert_id', $expert_id)->whereIn('status', ['doing', 'expert-violation'])->first();
            // if ($pastOrders) {
            //     return ResponseData::error('متخصص مشغول انجام سفارش دیگری است');
            // }
            $order->expert_id = $expert_id;
            $order->set_expert_at = Carbon::now();
            NotificationService::sendNotification("user", $order->user_id, $expert_id, "expert", $order->id, null, "accept-proposal");
            $order->status = "doing";
            OrderStatusService::setStatus($order->id, "doing");
            $order->save();

            return ResponseData::success("عملیات با موفقیت انجام شد");
        } catch (Exception $ex) {
            return ResponseData::error($ex->getMessage());
        }
    }

    public function confirm(Request $req)
    {
        $id = $req->id;
        Order::where('id', $id)->update(['status' => 'done', 'completed_at' => Carbon::now()]);
        return ResponseData::success("عملیات با موفقیت انجام شد");
    }
}
