<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\ResponseData;
use App\Http\Controllers\Controller;
use App\Models\Banner;
use App\Models\Slider;
use Exception;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function slider(Request $req)
    {
        $slider = Slider::orderByDesc('created_at')->get();
        return ResponseData::success('Slider', $slider);
    }

    public function addSlide(Request $req)
    {
        $image = $req->image;
        $link = $req->link;
        try {
            Slider::create([
                'image' => $image,
                'link' => $link
            ]);

            return ResponseData::success('Slider Created');
        } catch (Exception $ex) {
            return ResponseData::error('خطا در ثبت اسلاید');
        }
    }

    public function updateSlide(Request $req)
    {
        $id = $req->id;
        $image = $req->image;
        $link = $req->link;
        try {
            Slider::where('id', $id)->update([
                'image' => $image,
                'link' => $link
            ]);

            return ResponseData::success('Slider updated');
        } catch (Exception $ex) {
            return ResponseData::error('خطا در ثبت اسلاید');
        }
    }

    public function deleteSlide(Request $req)
    {
        $id = $req->id;
        Slider::where('id', $id)->delete();

        return ResponseData::success('Done');
    }

    public function getBanners(Request $req)
    {

        try {
           $banners= Banner::get();
            return ResponseData::success('تغییرات با موفقیت ثبت شد',$banners);
        } catch (Exception $e) {
            return ResponseData::error('خطا در ثبت تغییرات');
        }
    }

    public function editBanner(Request $req)
    {
        $title = $req->title;
        $attachment = $req->attachment;
        $link = $req->link;

        try {
            $currentBanner= Banner::where('title', $title)->first();
            if($currentBanner){
                $currentBanner->attachment= $attachment;
                $currentBanner->link= $link;
                $currentBanner->save();
            }
            else{
                Banner::create([
                    'title'=>$title,
                    'attachment'=> $attachment,
                    'link'=> $link
                ]);
            }

            return ResponseData::success('تغییرات با موفقیت ثبت شد');
        } catch (Exception $e) {
            return ResponseData::error('خطا در ثبت تغییرات');
        }
    }
}
