<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\ResponseData;
use App\Http\Controllers\Controller;
use App\Http\Resources\Expert\ExpertResource;
use App\Models\Expert;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ExpertController extends Controller
{
    public function index(Request $req)
    {
        $query = Expert::query();
        if ($req->query('search', null) != null) {
            $q = $req->query('search', null);
            $query->where(DB::raw("CONCAT(first_name, ' ', last_name)"), 'like', "%$q%");
        }

        $data = $query->paginate(20);
        return ExpertResource::collection($data);
    }

    public function details($id)
    {
        $data = Expert::where('id', $id)->first();
        return ResponseData::success('expert details', new ExpertResource($data));
    }

    public function create(Request $req)
    {
        $first_name = $req->first_name;
        $last_name = $req->last_name;
        $national_code = $req->national_code;
        $mobile = $req->mobile;

        try {
            Expert::create([
                'first_name' => $first_name,
                'last_name' => $last_name,
                'national_code' => $national_code,
                'mobile' => $mobile,
            ]);

            return ResponseData::success('Done');
        } catch (Exception $ex) {
              return ResponseData::error($ex->getMessage());
            return ResponseData::error('خطا در ثبت متخصص');
        }
    }

    public function update(Request $req)
    {
        $id = $req->id;
        $first_name = $req->first_name;
        $last_name = $req->last_name;
        $national_code = $req->national_code;
        $mobile = $req->mobile;

        try {
            Expert::where('id', $id)->update([
                'first_name' => $first_name,
                'last_name' => $last_name,
                'national_code' => $national_code,
                'mobile' => $mobile,
            ]);

            return ResponseData::success('Done');
        } catch (Exception $ex) {
            return ResponseData::error('خطا در ثبت متخصص');
        }
    }

    public function delete(Request $req){
        Expert::where('id', $req->id)->delete();
        return ResponseData::success('done');
    }
}
