<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\ResponseData;
use App\Http\Controllers\Controller;
use App\Models\Expert;
use App\Models\Order;
use App\Models\Service;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    public function statics(Request $req)
    {
        $date = $req->date;
        $start = Carbon::parse($req->start)->toJalali();
        $end =  Carbon::parse($req->end)->toJalali();

        $totalUsers = User::count();
        $totalOrders = Order::where('status', '!=', 'canceled')->count();
        $totalCompletedOrders = Order::where('status', 'user-confirm')->count();

        if ($date == "today") {
            $startDate = verta()->startDay();
            $endDate = verta()->endDay();
        } else if ($date == "weekly") {
            $startDate = verta()->subDays(7)->startDay();
            $endDate = verta()->endDay();
        } else if ($date == "monthly") {
            $startDate = verta()->subDays(30);
            $endDate = verta()->endDay();
        } else {
            $startDate = $start->startDay();
            $endDate = $end->endDay();
        }
        $users = User::whereBetween('created_at', [$startDate->toCarbon(), $endDate->toCarbon()])->count();
        $orders = Order::where('status', '!=', 'canceled')->whereBetween('created_at', [$startDate->toCarbon(), $endDate->toCarbon()])->count();
        $completedOrders = Order::where('status', 'user-confirm')->whereBetween('created_at', [$startDate, $endDate])->count();

        return ResponseData::success('statics', [
            'totalUsers' => $totalUsers,
            'totalOrders' => $totalOrders,
            'totalCompletedOrders' => $totalCompletedOrders,
            'users' => $users,
            'orders' => $orders,
            'completedOrders' => $completedOrders,
        ]);
    }

    public function  userChart(Request $req)
    {
        $date = $req->date;
        $start = Carbon::parse($req->start)->toJalali();
        $end =  Carbon::parse($req->end)->toJalali();


        $data = [];
        if ($date == "today") {
            for ($i = 0; $i < 24; $i++) {
                $startDate = verta()->startDay()->addHours($i);
                $endDate = verta()->startDay()->addHours($i + 1);

                $users = User::whereBetween('created_at', [$startDate->toCarbon(), $endDate->toCarbon()])->count();
                array_push($data, [
                    'date' => $startDate->format('H'),
                    'value' => $users
                ]);
            }
        } else if ($date == "weekly") {
            $startWeek = verta()->subDays(7);
            for ($i = 0; $i < 7; $i++) {
                $dt = $startWeek->addDay();

                $users = User::whereBetween('created_at', [$dt->startDay()->toCarbon(), $dt->endDay()->toCarbon()])->count();
                array_push($data, [
                    'date' => $dt->format('m-d'),
                    'value' => $users
                ]);
            }
        } else if ($date == "monthly") {
            $startMonth = verta()->subDays(30);
            for ($i = 0; $i < 30; $i++) {
                $dt = $startMonth->addDay();

                $users = User::whereBetween('created_at', [$dt->startDay()->toCarbon(), $dt->endDay()->toCarbon()])->count();
                array_push($data, [
                    'date' => $dt->format('m-d'),
                    'value' => $users
                ]);
            }
        } else {
            $diff = $end->diffDays($start);
            for ($i = 0; $i < $diff; $i++) {
                $dt = $start->addDay();

                $users = User::whereBetween('created_at', [$dt->startDay()->toCarbon(), $dt->endDay()->toCarbon()])->count();
                array_push($data, [
                    'date' => $dt->format('y-m-d'),
                    'value' => $users
                ]);
            }
        }

        return ResponseData::success('user chart', $data);
    }

    public function  orderChart(Request $req)
    {
        $date = $req->date;
        $start = Carbon::parse($req->start)->toJalali();
        $end =  Carbon::parse($req->end)->toJalali();


        $data = [];
        if ($date == "today") {
            for ($i = 0; $i < 24; $i++) {
                $startDate = verta()->startDay()->addHours($i);
                $endDate = verta()->startDay()->addHours($i + 1);

                $orders = Order::where('status', '!=', 'canceled')->whereBetween('created_at', [$startDate->toCarbon(), $endDate->toCarbon()])->count();
                array_push($data, [
                    'date' => $startDate->format('H'),
                    'value' => $orders
                ]);
            }
        } else if ($date == "weekly") {
            $startWeek = verta()->subDays(7);
            for ($i = 0; $i < 7; $i++) {
                $dt = $startWeek->addDay();
                $orders = Order::where('status', '!=', 'canceled')->whereBetween('created_at', [$dt->startDay()->toCarbon(), $dt->endDay()->toCarbon()])->count();
                array_push($data, [
                    'date' => $dt->format('m-d'),
                    'value' => $orders,
                ]);
            }
        } else if ($date == "monthly") {
            $startMonth = verta()->subDays(30);
            for ($i = 0; $i < 30; $i++) {
                $dt = $startMonth->addDay();

                $orders = Order::where('status', '!=', 'canceled')->whereBetween('created_at', [$dt->startDay()->toCarbon(), $dt->endDay()->toCarbon()])->count();
                array_push($data, [
                    'date' => $dt->format('m-d'),
                    'value' => $orders,
                ]);
            }
        } else {
            $diff = $end->diffDays($start);
            for ($i = 0; $i < $diff; $i++) {
                $dt = $start->addDay();

                $orders = Order::where('status', '!=', 'canceled')->whereBetween('created_at', [$dt->startDay()->toCarbon(), $dt->endDay()->toCarbon()])->count();
                array_push($data, [
                    'date' => $dt->format('y-m-d'),
                    'value' => $orders
                ]);
            }
        }

        return ResponseData::success('user chart', $data);
    }

    public function topServices(Request $req)
    {
        $date = $req->date;
        $start = Carbon::parse($req->start)->toJalali();
        $end =  Carbon::parse($req->end)->toJalali();

        if ($date == "today") {
            $startDate = verta()->startDay();
            $endDate = verta()->endDay();
        } else if ($date == "weekly") {
            $startDate = verta()->subDays(7)->startDay();
            $endDate = verta()->endDay();
        } else if ($date == "monthly") {
            $startDate = verta()->subDays(30);
            $endDate = verta()->endDay();
        } else {
            $startDate = $start->startDay();
            $endDate = $end->endDay();
        }
        $service_ids = DB::table('orders')
            ->where('status', '!=', 'canceled')
            ->whereBetween('created_at', [$startDate->toCarbon(), $endDate->toCarbon()])
            ->select('service_id', DB::raw('count(*) as total'))
            ->groupBy('service_id')
            ->orderByDesc('total')
            ->limit(8)->get();

        $res = [];
        foreach ($service_ids as $serv) {
            $service = Service::where('id', $serv->service_id)->first();
            array_push($res, ['service' => $service, 'total' => $serv->total]);
        }
        return ResponseData::success('statics', $res);
    }
}
