<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\ResponseData;
use App\Http\Controllers\Controller;
use App\Http\Resources\Admin\AdminResource;
use App\Models\Admin;
use Illuminate\Http\Request;

class AuthController extends Controller
{
    public function login(Request $req){
        $credentials = $req->only(['username', 'password']);
        $user = Admin::where('username', $req->username)->first();

        if (!$user) {
            return ResponseData::error("نام کاربری یا رمز عبور نادرست است", null, 403);
        }
        if (!$token = auth()->guard('admins')->attempt($credentials)) {
            return ResponseData::error(" نام کاربری یا رمز عبور نادرست است", null, 403);
        }

        return $this->respondWithToken($token);
    }

    public function register(Request $req){
        Admin::create([
            'name'=>'admin',
            'username'=>"admin",
            'password'=> bcrypt('1234'),
            'role'=>'full'
        ]);

        return ResponseData::success('Done');
    }

    protected function respondWithToken($token)
    {
        $data = [
            'access_token' => $token,
            'token_type' => 'bearer',
            'user' => new AdminResource(auth()->guard('admins')->user()),
            'expires_in' => auth()->guard('admins')->factory()->getTTL() * 60
        ];
        return ResponseData::success('خوش آمدید', $data);
    }
}
