<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Spatie\Sitemap\Tags\Url;

class Sitemap extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sitemap:create-sitemap';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Daily sitemap creation';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {

        $sitemap = \Spatie\Sitemap\Sitemap::create()
            ->add('https://karaviz.com')
            ->add('https://karaviz.com/search')
            ->add('https://karaviz.com/search/expert')
            ->add('https://karaviz.com/explore')
            ->add('https://karaviz.com/explore/details/all');

        $categories = \App\Models\Category::where('parent', 0)->get();
        foreach ($categories as $category) {
            $sitemap->add("https://karaviz.com/category/{$category->id}");
            $subCategories = \App\Models\Category::where('parent', $category->id)->get();
            foreach ($subCategories as $subCategory) {
                $sitemap->add("https://karaviz.com/sub-category/{$category->id}/{$subCategory->id}");
            }
        }

        $services = \App\Models\Service::all();
        foreach ($services as $service) {
            $sitemap->add("https://karaviz.com/service/{$service->id}");
        }


        $sitemap->writeToFile(public_path('sitemap.xml'));
    }
}
